VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Catalog"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"32FA94AD02D9"
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
'
' catalog.cls
'
Option Base 0
Option Explicit
Implements ObjectControl

Private oDCatalog As DpkgCatalog.DCatalog

Private oObjectContext As ObjectContext

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = True
End Function

Private Sub ObjectControl_Deactivate()
    Set oObjectContext = Nothing
    Set oDCatalog = Nothing
End Sub

Private Sub ObjectControl_Activate()
    On Error GoTo OCActivateErr
   
    Set oObjectContext = GetObjectContext()
    Set oDCatalog = oObjectContext.CreateInstance("DpkgCatalog.DCatalog")
       
    Exit Sub

OCActivateErr:
    Call RaiseError("OCActivate")

End Sub


Public Function GetCatalogListByInterests(ByVal vInterests As Variant) As Variant
    On Error GoTo GetCatalogListByInterestsErr

    Dim vResponse As Variant
    Dim vCatalog As Variant
    Dim vCatalogItem As Variant
    Dim vProductTypes As Variant
    Dim vPublicationDate As Variant
    Dim vTodaysPrice As Variant
    Dim vPrice As Variant
    Dim vPromotionCode As Variant
    Dim vPromotionEndDate As Variant
    Dim vPromotionFlag As Variant
    Dim vNewFlag As Variant
    Dim vInterestCodes As Variant
    Trace "Extracting Interest Codes"
    vInterestCodes = ExtractInterestCodes(vInterests)
    Trace "Calling DCatalog.GetCatalogItemsByTypes"
    Set vResponse = oDCatalog.GetCatalogItemsByTypes(vInterestCodes)
    If Not vResponse("error") Then
    
        Set vCatalog = vResponse("items")
            
        For Each vCatalogItem In vCatalog
    
            vPublicationDate = CDate(vCatalogItem("publicationdate"))
            vPrice = vCatalogItem("price")
            vPromotionCode = vCatalogItem("promotioncode")
            vPromotionEndDate = vCatalogItem("promotionenddate")
                    
            If DateDiff("d", Now, DateAdd("m", 3, vPublicationDate)) > 0 Then
                vNewFlag = True
            Else
                vNewFlag = False
            End If
            
            vCatalogItem.Add vNewFlag, Key:="newflag"
            vTodaysPrice = AdjustTodaysPrice(vPrice, vPromotionCode, vPromotionEndDate)
            
            If vTodaysPrice = vPrice Then
                vPromotionFlag = False
            Else
                vPromotionFlag = True
            End If
            
           vTodaysPrice = Format(vTodaysPrice, "$#,##0.00")
    
           vCatalogItem.Add vTodaysPrice, Key:="todaysprice"
           vCatalogItem.Add vPromotionFlag, Key:="promotionflag"
            
        Next
               
    End If

    oObjectContext.SetComplete
    Set GetCatalogListByInterests = vResponse
         
    Exit Function
    
GetCatalogListByInterestsErr:
    oObjectContext.SetAbort
    Set GetCatalogListByInterests = RaiseError("GetCatalogListByInterests")
    
End Function

